/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.netty;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.function.Function;
import net.creeperhost.minetogether.connect.lib.netty.packet.CAccepted;
import net.creeperhost.minetogether.connect.lib.netty.packet.CBeginRaw;
import net.creeperhost.minetogether.connect.lib.netty.packet.CDisconnect;
import net.creeperhost.minetogether.connect.lib.netty.packet.CFriendServers;
import net.creeperhost.minetogether.connect.lib.netty.packet.CHello;
import net.creeperhost.minetogether.connect.lib.netty.packet.CPong;
import net.creeperhost.minetogether.connect.lib.netty.packet.CRaw;
import net.creeperhost.minetogether.connect.lib.netty.packet.CServerLink;
import net.creeperhost.minetogether.connect.lib.netty.packet.MDisconnect;
import net.creeperhost.minetogether.connect.lib.netty.packet.MEncrypt;
import net.creeperhost.minetogether.connect.lib.netty.packet.MHello;
import net.creeperhost.minetogether.connect.lib.netty.packet.MHostUpdate;
import net.creeperhost.minetogether.connect.lib.netty.packet.MPing;
import net.creeperhost.minetogether.connect.lib.netty.packet.MPong;
import net.creeperhost.minetogether.connect.lib.netty.packet.Packet;
import net.creeperhost.minetogether.connect.lib.netty.packet.SHello;
import net.creeperhost.minetogether.connect.lib.netty.packet.SHostConnect;
import net.creeperhost.minetogether.connect.lib.netty.packet.SHostRegister;
import net.creeperhost.minetogether.connect.lib.netty.packet.SMeshConnect;
import net.creeperhost.minetogether.connect.lib.netty.packet.SPing;
import net.creeperhost.minetogether.connect.lib.netty.packet.SRaw;
import net.creeperhost.minetogether.connect.lib.netty.packet.SRequestFriendServers;
import net.creeperhost.minetogether.connect.lib.netty.packet.SUserConnect;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.FastStream;

public enum PacketType {
    C_HELLO(CHello.class, CHello::new),
    C_FRIEND_SERVERS(CFriendServers.class, CFriendServers::new),
    C_DISCONNECTED(CDisconnect.class, CDisconnect::new),
    C_ACCEPTED(CAccepted.class, CAccepted::new),
    C_SERVER_LINK(CServerLink.class, CServerLink::new),
    C_BEGIN_RAW(CBeginRaw.class, CBeginRaw::new),
    C_RAW(CRaw.class, CRaw::new),
    C_PONG(CPong.class, CPong::new),
    S_HELLO(SHello.class, SHello::new),
    S_FRIEND_SERVERS(SRequestFriendServers.class, SRequestFriendServers::new),
    S_HOST_REGISTER(SHostRegister.class, SHostRegister::new),
    S_HOST_CONNECT(SHostConnect.class, SHostConnect::new),
    S_USER_CONNECT(SUserConnect.class, SUserConnect::new),
    S_MESH_CONNECT(SMeshConnect.class, SMeshConnect::new),
    S_RAW(SRaw.class, SRaw::new),
    S_PING(SPing.class, SPing::new),
    M_HELLO(MHello.class, MHello::new),
    M_DISCONNECT(MDisconnect.class, MDisconnect::new),
    M_ENCRYPT(MEncrypt.class, MEncrypt::new),
    M_PING(MPing.class, MPing::new),
    M_PONG(MPong.class, MPong::new),
    M_HOST_UPDATE(MHostUpdate.class, MHostUpdate::new);

    public static final PacketType[] VALUES;
    public static final Map<Class<? extends Packet<?>>, PacketType> PACKETS;
    public final Class<? extends Packet<?>> packetClass;
    public final Function<ByteBuf, ? extends Packet<?>> packetCtor;

    private <C extends Packet<?>> PacketType(Class<C> packetClass, Function<ByteBuf, C> packetCtor) {
        this.packetClass = packetClass;
        this.packetCtor = packetCtor;
        if (!Modifier.isFinal(packetClass.getModifiers())) {
            throw new IllegalArgumentException("Packet class " + packetClass.getName() + " should be final.");
        }
    }

    static {
        VALUES = PacketType.values();
        PACKETS = FastStream.of(VALUES).toImmutableMap(e -> e.packetClass, e -> e);
    }
}

